/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import java.util.List;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ItemListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class AutoSell
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<SellMode> mode;
    private final Setting<List<class_1792>> itemList;
    private final Setting<Integer> delay;
    private int delayCounter;
    private boolean shouldReopen;

    public AutoSell() {
        super(CatalystAddon.CATEGORY, "AutoSell", "Automatically sells items.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.mode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("Whether to whitelist or blacklist the selected items.")).defaultValue((Object)SellMode.Whitelist)).build());
        this.itemList = this.sgGeneral.add((Setting)((ItemListSetting.Builder)((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("items")).description("Items to sell.")).defaultValue(List.of(class_1802.field_17498))).build());
        this.delay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("Delay in ticks between actions.")).defaultValue((Object)1)).min(0).max(20).sliderMax(20).build());
        this.shouldReopen = false;
    }

    public void onActivate() {
        this.delayCounter = 20;
        this.shouldReopen = false;
    }

    public void onDeactivate() {
        this.shouldReopen = false;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null || this.mc.field_1761 == null) {
            return;
        }
        if (this.delayCounter > 0) {
            --this.delayCounter;
            return;
        }
        if (this.shouldReopen) {
            this.mc.method_1562().method_45730("sell");
            this.shouldReopen = false;
            this.delayCounter = (Integer)this.delay.get();
            return;
        }
        this.handleSellMode();
    }

    private void handleSellMode() {
        class_1703 currentScreenHandler = this.mc.field_1724.field_7512;
        if (!(currentScreenHandler instanceof class_1707)) {
            this.mc.method_1562().method_45730("sell");
            this.delayCounter = 20;
            return;
        }
        if (this.areAllSellSlotsOccupied(currentScreenHandler)) {
            this.info("All sell menu slots (0-35) are occupied. Closing and reopening menu.", new Object[0]);
            this.mc.field_1724.method_7346();
            this.shouldReopen = true;
            this.delayCounter = (Integer)this.delay.get();
            return;
        }
        int totalSlots = currentScreenHandler.field_7761.size();
        boolean foundItemToSell = false;
        for (int slot = 36; slot < totalSlots; ++slot) {
            class_1792 itemInSlot;
            class_1799 stack = currentScreenHandler.method_7611(slot).method_7677();
            if (stack.method_7960() || !this.shouldSellItem(itemInSlot = stack.method_7909())) continue;
            foundItemToSell = true;
            this.mc.field_1761.method_2906(currentScreenHandler.field_7763, slot, 0, class_1713.field_7794, (class_1657)this.mc.field_1724);
            this.delayCounter = (Integer)this.delay.get();
            return;
        }
        if (!foundItemToSell) {
            this.info("All items sold. Closing GUI.", new Object[0]);
            this.mc.field_1724.method_7346();
            this.toggle();
            this.delayCounter = 40;
        }
    }

    private boolean areAllSellSlotsOccupied(class_1703 screenHandler) {
        for (int slot = 0; slot <= 35; ++slot) {
            if (slot >= screenHandler.field_7761.size()) {
                return false;
            }
            class_1799 stack = screenHandler.method_7611(slot).method_7677();
            if (!stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    private boolean shouldSellItem(class_1792 item) {
        List selectedItems = (List)this.itemList.get();
        if (this.mode.get() == SellMode.Whitelist) {
            return selectedItems.contains(item);
        }
        return !selectedItems.contains(item);
    }

    public static enum SellMode {
        Whitelist,
        Blacklist;

    }
}

